/*************************************************
File:         BM25S3221-1_demo.ino
Description:
Note:
**************************************************/
#include "BM25S3221-1.h"  
#include <BMD58T280.h>    // TFT LCD library

#define PM1_0 dustValue[0]
#define PM2_5 dustValue[1]
#define PM10 dustValue[2]
uint16_t dustValue[3] = {0};
String tmp_data;
char char_data[6] = {0};

BM25S3221_1 air(STATUS1, &Serial1); // Hardware serial: Serial1
BMD58T280 tft;

void setup()
{
  air.begin();  // Initialize module: BM25S3221-1
  tft.begin();  // Initialize module: BMD58T280
  Serial.begin(115200); // Initialize Serial, baud rate: 115200bps

  /* Setup BM25S3221-1*/
  tft.setRotation(1);
  tft.background(BM_ILI9341::BLACK);
  tft.stroke(BM_ILI9341::WHITE);
  /* Setup BM25S3221-1*/
  preheart();
  air.setUploadMode(CMD);

  /*Initialize display*/
  tft.setTextSize(3);
  tft.text("BM25S3221-1", 64, 5, BM_ILI9341::WHITE, BM_ILI9341::BLACK);
  tft.text("Unit:ug/m", 144, 208, BM_ILI9341::WHITE, BM_ILI9341::BLACK);
  tft.setTextSize(1);
  tft.text("3", 307, 210, BM_ILI9341::WHITE, BM_ILI9341::BLACK);
  tft.setTextSize(4);
  tft.text("PM1.0:", 10, 64, BM_ILI9341::YELLOW, BM_ILI9341::BLACK);
  tft.text("PM2.5:", 10, 112, BM_ILI9341::YELLOW, BM_ILI9341::BLACK);
  tft.text("PM10: ", 10, 160, BM_ILI9341::YELLOW, BM_ILI9341::BLACK);
}

void loop()
{
  if (air.readDustValue(dustValue) == 0)
  {
    tmp_data = String(PM1_0);
    tmp_data += "   ";
    tmp_data.toCharArray(char_data, 6);
    tft.text(char_data, 160, 64, BM_ILI9341::YELLOW, BM_ILI9341::BLACK); //PM1.0
    tmp_data = String(PM2_5);
    tmp_data += "   ";
    tmp_data.toCharArray(char_data, 6);
    tft.text(char_data, 160, 112, BM_ILI9341::YELLOW, BM_ILI9341::BLACK); // PM2.5
    tmp_data = String(PM10);
    tmp_data += "   ";
    tmp_data.toCharArray(char_data, 6);
    tft.text(char_data, 160, 160, BM_ILI9341::YELLOW, BM_ILI9341::BLACK); // PM10

    Serial.print("PM1.0: ");
    Serial.print(PM1_0);
    Serial.println(" μg/m³");

    Serial.print("PM2.5: ");
    Serial.print(PM2_5);
    Serial.println(" μg/m³");

    Serial.print("PM10:  ");
    Serial.print(PM10);
    Serial.println(" μg/m³");
    Serial.println();
  }
  else
  {
    Serial.println("read failed!");
    tft.text("0   ", 160, 64, BM_ILI9341::RED, BM_ILI9341::BLACK); // PM1.0
    tft.text("0   ", 160, 112, BM_ILI9341::RED, BM_ILI9341::BLACK);// PM2.5
    tft.text("0   ", 160, 160, BM_ILI9341::RED, BM_ILI9341::BLACK); // PM10
  }
  delay(500);
}

void preheart()
{
  char char_time[3] = {0};
  tft.setTextSize(4);
  tft.text("Preheating", 42, 5, BM_ILI9341::WHITE, BM_ILI9341::BLACK);
  Serial.println("Module preheating...(about 30 second)");
  for (uint8_t time = 1; time < 31; time++)
  {
    tmp_data = String(time);
    Serial.println(tmp_data);
    tmp_data.toCharArray(char_time, 3);
    tft.setTextSize(20);
    if (time < 10)
    {
      tft.text(char_time, 110, 65, BM_ILI9341::WHITE, BM_ILI9341::BLACK);
    }
    else
    {
      tft.text(char_time, 50, 65, BM_ILI9341::WHITE, BM_ILI9341::BLACK);
    }
    delay(1000);
  }
  tft.text("  ", 50, 65, BM_ILI9341::WHITE, BM_ILI9341::BLACK);
  tft.setTextSize(4);
  tft.text("          ", 42, 5, BM_ILI9341::WHITE, BM_ILI9341::BLACK);
  Serial.println("End of module preheating.");
  Serial.println();
}